#pragma once

#define STATUS_RUNNING 0
#define STATUS_DEAD 1
#define STATUS_SLEEPING 2

#define MAX_STACK_SIZE 1024
#define MAX_RECURSION_DEPTH 1024

#define ERR_STACKOVERFLOW -1

#include "stack.h"
//****************************************************************************************************************
//Trida ktera predstavuje jednu promennou v zasobniku, promenna muze byt typu int, double nebo string
//****************************************************************************************************************
class StackItem
{
public:
	int			kind;		//je zde ulozen integer, double nebo retezec
	union					//misto pro ulozeni hodnoty
	{
		int		intval;			
		char*	strval;
		double	doubleval;
	};

public:

	//funkce pro pretypovani hodnoty, nazvy rikaji vse
	inline void					Cast_inttodouble();	
	inline void					Cast_inttostring();
	
	inline void					Cast_doubletoint();
	inline void					Cast_doubletostring();

	inline void					Cast_stringtodouble();
    inline void					Cast_stringtoint();

	//operatory, pro snazsi kod ve tride VirtualMachine
	bool operator == (StackItem &right);
	bool operator < (StackItem &right);
	bool operator > (StackItem &right);
	bool operator <= (StackItem &right);
	bool operator >= (StackItem &right);
	bool operator != (StackItem &right);

	StackItem operator + (StackItem &right);
	StackItem operator - (StackItem &right);
	StackItem operator * (StackItem &right);
	StackItem operator / (StackItem &right);
	StackItem operator % (StackItem &right);
	StackItem operator << (StackItem &right);
	StackItem operator >> (StackItem &right);
	StackItem& operator -- ();		//prefix --
	StackItem  operator -- (int);	//postfix --
	StackItem& operator ++ ();		//prefix ++
	StackItem  operator ++ (int);	//postfix ++
	StackItem operator & (StackItem &right);
	StackItem operator | (StackItem &right);
	void operator = (StackItem &right);
};

//****************************************************************************************************************
//reprezentuje jakysi task state segment pro funkci
//****************************************************************************************************************
struct	ActivationStackItem
{
	unsigned int	endCode;
	int				PC,BSP,SP;
	unsigned int	numberOfParams;
};

//****************************************************************************************************************
//trida reprezentujici instanci funkce se vsemi potrebnymi zdroji a obsluznymi funkcemi
//****************************************************************************************************************
class CFunctionInstance
{
private:
	CStack<StackItem>				Stack;						//zasobnik pro provadeni vypoctu
	CStack<ActivationStackItem>		ActivationStack;			//zasobnik pro ukladani volani fci
	int								iCurrActivation;			//ukazatel na vrchol zasobniku definovaneho o lajnu vejs

public:
	FUNCTION_HEADER*				function;					//ukazatel na hlavicku funkce
public:
	CFunctionInstance(void);
	~CFunctionInstance(void);

	BYTE							status;
	//vrati ukazatel na zasobnik pro vypocty
	CStack<StackItem>*				GetStack()								{return &Stack;}
	//vrati ukazatel na zasobnik pro volani funkci
	CStack<ActivationStackItem>*	GetActivationStack()					{return &ActivationStack;}	
	//pro ulozeni nove polozky na zasobnik pro volani funkci pri volani funkce. 
	HRESULT							PushActivation();
	//pri navrati z funkce
	void							PopActivation();
	//vrati obsah citace PC - Program Counter - citatc instrukci
	unsigned int					GetPC()									{return ActivationStack[iCurrActivation].PC;}
	//vrati obsah citace BSP - Base Stack Pointer - ukazatel dna zasobniku
	unsigned int					GetBSP()								{return ActivationStack[iCurrActivation].BSP;}
	//vrati obsah citace SP - Stack pointer - ukazatel vrcholu zasobniku
	unsigned int					GetSP()									{return ActivationStack[iCurrActivation].SP;}
	//vrati pocet parametru funkce
	unsigned int					GetNumberOfParams()						{return ActivationStack[iCurrActivation].numberOfParams;}
	//vrati adresu (offset) v kodovem segmentu kde konci telo funkce
	unsigned int					GetEndCode()							{return ActivationStack[iCurrActivation].endCode;}
	//Funkce pro praci s polozkami struktury ActivationStackItem, ktera predstavuje jednu polozku v zasobniku pro volani funkci
	//a udrzuje v sobe informace o stavu provadene funkce a informace nutne k provadeni funkce
	void							AddPC(int offset)						{ActivationStack[iCurrActivation].PC += offset;}	
	void							SetPC(unsigned int adress)				{ActivationStack[iCurrActivation].PC = adress;}	
	void							AddSP(int offset)						{ActivationStack[iCurrActivation].SP += offset;}	
	void							SetSP(unsigned int adress)				{ActivationStack[iCurrActivation].SP = adress;}
	void							SetEndCode(unsigned int adress)			{ActivationStack[iCurrActivation].endCode = adress;}
	void							SetNumberOfParams(unsigned int params)	{ActivationStack[iCurrActivation].numberOfParams = params;}
	void							SetBSP(unsigned int adress)				{ActivationStack[iCurrActivation].BSP = adress;}
	//Funkce pro praci se zasobnikem pro volani funkci
	//zvyseni vrcholu zasobniku o 1
	void							Push()									{ActivationStack[iCurrActivation].SP++;}
	//snizeni vrcholu zasobniku o dany pocet 
	void							Pop(int number = 1);
	//Funkce pro praci se zasobnikem pro vypocty
	//Funkce pro ukladani hodnot na vrchol zasobniku
	void							PushInt(int i);
	void							PushString(char* str);
	void							PushDouble(double i);
	void							PushStackItem(StackItem s);
	//Funkce pro vyber hodnot z vrcholu zasobniku
	int								PopInt();
	char*							PopString();
	double							PopDouble();
	StackItem						PopStackItem();
	//Funkce pro vraceni typu promenne v zasobniku nebo lokalni promenne
	//Rozdil je jen v adresaci promennych v zasobniku
	int								GetStackVariableKind(int offset = 0);
    int								GetLocalVariableKind(int offset = 0);						
	//Funkce pro nastaveni hodnoty promenne na urcite pozici v zasobniku
	void							SetInt(int i, int offset = 0);			
	void							SetString(char* s, int offset = 0);	
	void							SetDouble(double i, int offset = 0);
	void							SetStackItem(StackItem s,int offset = 0); 
	//Funkce pro vraceni hodnoty promenne na urcite pozici v zasobniku
	int								GetInt(int offset = 0);					
	char*							GetString(int offset = 0);				
	double							GetDouble(int offset = 0);																		
	StackItem						GetStackItem(int offset = 0);			
	//Funkce pro vraceni lokalni promenne
	int								GetLocalInt(int offset = 0);			
	char*							GetLocalString(int offset = 0);			
	double							GetLocalDouble(int offset = 0);																																		
	//Funkce pro nastaveni lokalni promenne
	void							SetLocalInt(int i, int offset = 0);		
	void							SetLocalString(char* s, int offset = 0);
	void							SetLocalDouble(double i,int offset = 0);																		
};
